import { Injectable } from '@angular/core';
import { Headers, Http } from '@angular/http';
import 'rxjs/add/operator/toPromise';
import { NgbDateParserFormatter } from '@ng-bootstrap/ng-bootstrap';

import { AppSettings } from '../../../app.settings';
import { Right } from '../models/right';

@Injectable()
export class RightService {
  private headers = new Headers({ 'Content-Type': 'application/json' });
  private rightsUrl = AppSettings.API_ENDPOINT + 'right';  // URL to web api
  constructor(
    private http: Http,
    private parserFormatter: NgbDateParserFormatter
  ) { }

  getRights(): Promise<Right[]> {
    return this.http.get(this.rightsUrl)
      .toPromise()
      .then(response =>
        response.json() as Right[])
      ;
  }

  getRightsForCombo(): Promise<Right[]> {
    return this.http.get(this.rightsUrl + "/get-rights-for-combo")
      .toPromise()
      .then(response =>
        response.json() as Right[])
      ;
  }

  getRight(id: number): Promise<Right> {
    const url = `${this.rightsUrl}/${id}`;
    return this.http.get(url)
      .toPromise()
      .then(response => response.json() as Right);
  }

  createRight(right: Right): Promise<Right> {
    return this.http
      .post(this.rightsUrl, JSON.stringify(right), { headers: this.headers })
      .toPromise()
      .then(res => res.json())
      .catch(this.handleError);
  }

  updateRight(right: Right): Promise<Right> {
    return this.http
      .put(this.rightsUrl, JSON.stringify(right), { headers: this.headers })
      .toPromise()
      .then(res => res.json())
      .catch(this.handleError);
  }

  deleteRight(id: number): Promise<void> {
    const url = `${this.rightsUrl}/${id}`;
    return this.http.delete(url)
      .toPromise()
      .then(() => { });
  }

  private handleError(error: any): Promise<any> {
    console.error('An error occurred', error);
    return Promise.reject(error.message || error);
  }

}
