//built in angular modules
import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { HttpModule } from '@angular/http';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';

//external modules
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { SelectModule } from 'ng2-select';

//own modules
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { UsersComponent } from './modules/users/users.component';
import { UserService } from './modules/users/services/user.service';
import { UserComponent } from './modules/users/user/user.component';

import { RightsComponent } from './modules/rights/rights.component';
import { RightComponent } from './modules/rights/right/right.component';
import { RightService } from './modules/rights/services/right.service';

@NgModule({
  declarations: [
    AppComponent,
    UsersComponent,
    UserComponent,
    RightsComponent,
    RightComponent,
  ],
  imports: [
    BrowserModule,
    FormsModule,
    ReactiveFormsModule,
    HttpModule,
    AppRoutingModule,
    NgbModule.forRoot(),
    SelectModule,
  ],
  providers: [UserService, RightService],
  bootstrap: [AppComponent]
})

export class AppModule { }
