import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { UsersComponent } from './modules/users/users.component';
import { UserComponent } from './modules/users/user/user.component';
import { RightsComponent } from './modules/rights/rights.component';
import { RightComponent } from './modules/rights/right/right.component';
const routes: Routes = [
  {
    path: '',
    children: []
  },
  //Users
  {
    path: 'users',
    component: UsersComponent
  },
  {
    path: 'users/edit/:id',
    component: UserComponent
  },
  {
    path: 'users/create',
    component: UserComponent
  },
  {
    path: 'users/details/:id',
    component: UserComponent
  },
  //Rights
  {
    path: 'rights',
    component: RightsComponent
  },
  {
    path: 'rights/edit/:id',
    component: RightComponent
  },
  {
    path: 'rights/create',
    component: RightComponent
  },
  {
    path: 'rights/details/:id',
    component: RightComponent
  }

];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
