import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { User } from './models/user';
import { UserService } from './services/user.service';
import { NgbDateStruct } from '@ng-bootstrap/ng-bootstrap';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';


@Component({
  selector: 'app-users',
  templateUrl: './users.component.html',
  styleUrls: ['./users.component.less']
})
export class UsersComponent implements OnInit {
  users: User[];

  constructor(
    private userService: UserService,
    private router: Router) { }

  getUsers(): void {
    this.userService
      .getUsers()
      .then(users => this.users = users);
  }

  ngOnInit() {
    this.getUsers();
  }

  details(id): void {
    this.router.navigate(['/users/details', id]);
  }

  edit(id): void {
    this.router.navigate(['/users/edit', id]);
  }

}
