import 'rxjs/add/operator/switchMap';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Params } from '@angular/router';
import { Location } from '@angular/common';
import { NgbDateParserFormatter } from '@ng-bootstrap/ng-bootstrap';

import { User } from '../models/user';
import { UserService } from '../services/user.service'

@Component({
  selector: 'app-user',
  templateUrl: './user.component.html',
  styleUrls: ['./user.component.less']
})
export class UserComponent implements OnInit {
  user: User;
  editMode: boolean;
  title: string;

  constructor(
    private userService: UserService,
    private route: ActivatedRoute,
    private location: Location,
    private parserFormatter: NgbDateParserFormatter

  ) { }

  ngOnInit(): void {
    this.user = new User();
    this.editMode = true;
    this.route.params.subscribe(params => {
      if (params['id']) {
        this.userService.getUser(params['id'])
          .then(user => {
            this.user = user
          });
      }
      if (this.location.path().indexOf('details') > -1) {
        this.editMode = false;
        this.title = "Details";
      }
      else {
        if (params['id'])
          this.title = "Edit";
        else {
          this.title = "Create";
          this.user = new User();
        }
      }
    });
  }


  save(): void {
    this.userService.createUser(this.user)
      .then(() => this.goBack());
  }

  goBack(): void {
    this.location.back();
  }
}
