import { Injectable } from '@angular/core';
import { Headers, Http } from '@angular/http';
import 'rxjs/add/operator/toPromise';
import { NgbDateParserFormatter } from '@ng-bootstrap/ng-bootstrap';

import { User } from '../models/user';
@Injectable()
export class UserService {

  private headers = new Headers({ 'Content-Type': 'application/json' });
  private usersUrl = 'api/user';  // URL to web api
  constructor(
    private http: Http,
    private parserFormatter: NgbDateParserFormatter
  ) { }

  getUsers(): Promise<User[]> {
    return this.http.get('http://192.168.50.183:1337/' + this.usersUrl)
      .toPromise()
      .then(response =>
        response.json().users as User[])
      ;
  }

  getUser(id: number): Promise<User> {
    const url = `${this.usersUrl}/${id}`;
    return this.http.get('http://192.168.50.183:1337/' + url)
      .toPromise()
      .then(response => {
        let user = response.json().user as User;
        user.BirthDate = this.parserFormatter.parse(user.BirthDate);
        return user;
      });
  }

  createUser(user: User): Promise<User> {
    user.BirthDate = this.parserFormatter.format(user.BirthDate);
    return this.http
      .post('http://192.168.50.183:1337/' + this.usersUrl, JSON.stringify(user), { headers: this.headers })
      .toPromise()
      .then(res => res.json().user)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    console.error('An error occurred', error);
    return Promise.reject(error.message || error);
  }

}
