import { Injectable } from '@angular/core';
import { Headers, Http } from '@angular/http';
import 'rxjs/add/operator/toPromise';
import { NgbDateParserFormatter } from '@ng-bootstrap/ng-bootstrap';

import { Right } from '../models/right';

@Injectable()
export class RightService {
  private headers = new Headers({ 'Content-Type': 'application/json' });
  private rightsUrl = 'api/right';  // URL to web api
  constructor(
    private http: Http,
    private parserFormatter: NgbDateParserFormatter
  ) { }


  getRights(): Promise<Right[]> {
    return this.http.get('http://192.168.50.183:1337/' + this.rightsUrl)
      .toPromise()
      .then(response =>
        response.json().rights as Right[])
      ;
  }

  getRight(id: number): Promise<Right> {
    const url = `${this.rightsUrl}/${id}`;
    return this.http.get('http://192.168.50.183:1337/' + url)
      .toPromise()
      .then(response => response.json().right as Right);
  }

  createRight(right: Right): Promise<Right> {
    return this.http
      .post('http://192.168.50.183:1337/' + this.rightsUrl, JSON.stringify(right), { headers: this.headers })
      .toPromise()
      .then(res => res.json().right)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    console.error('An error occurred', error);
    return Promise.reject(error.message || error);
  }

}
