import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { Right } from './models/right';
import { RightService } from './services/right.service';

@Component({
  selector: 'app-rights',
  templateUrl: './rights.component.html',
  styleUrls: ['./rights.component.less']
})
export class RightsComponent implements OnInit {
  rights: Right[];
  constructor(
    private rightService: RightService,
    private router: Router) { }

  getRights(): void {
    this.rightService
      .getRights()
      .then(rights => this.rights = rights);
  }

  ngOnInit() {
    this.getRights();
  }

  details(id): void {
    this.router.navigate(['/rights/details', id]);
  }

  edit(id): void {
    this.router.navigate(['/rights/edit', id]);
  }

}
