import 'rxjs/add/operator/switchMap';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Params } from '@angular/router';
import { Location } from '@angular/common';

import { Right } from '../models/right';
import { RightService } from '../services/right.service'

@Component({
  selector: 'app-right',
  templateUrl: './right.component.html',
  styleUrls: ['./right.component.less']
})
export class RightComponent implements OnInit {

  right: Right;
  editMode: boolean;
  title: string;

  constructor(
    private rightService: RightService,
    private route: ActivatedRoute,
    private location: Location,

  ) { }

  ngOnInit(): void {
    this.right = new Right();
    this.editMode = true;
    this.route.params.subscribe(params => {
      if (params['id']) {
        this.rightService.getRight(params['id'])
          .then(right => {
            this.right = right
          });
      }
      if (this.location.path().indexOf('details') > -1) {
        this.editMode = false;
        this.title = "Details";
      }
      else {
        if (params['id'])
          this.title = "Edit";
        else {
          this.title = "Create";
          this.right = new Right();
        }
      }
    });
  }

  save(): void {
    this.rightService.createRight(this.right)
      .then(() => this.goBack());
  }

  goBack(): void {
    this.location.back();
  }

}
