import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { UsersComponent } from './modules/users/users.component';
import { UserService } from './modules/users/services/user.service';
import { UserComponent } from './modules/users/user/user.component';

import { RightsComponent } from './modules/rights/rights.component';
import { RightComponent } from './modules/rights/right/right.component';
import { RightService } from './modules/rights/services/right.service';

@NgModule({
  declarations: [
    AppComponent,
    UsersComponent,
    UserComponent,
    RightsComponent,
    RightComponent,
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpModule,
    AppRoutingModule,
    NgbModule.forRoot()
  ],
  providers: [UserService, RightService],
  bootstrap: [AppComponent]
})

export class AppModule { }
