import 'rxjs/add/operator/switchMap';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Params } from '@angular/router';
import { Location } from '@angular/common';
import { NgbDateParserFormatter } from '@ng-bootstrap/ng-bootstrap';

import { User } from '../models/user';
import { Right } from '../../rights/models/right';
import { UserService } from '../services/user.service'
import { RightService } from '../../rights/services/right.service'

@Component({
  selector: 'app-user',
  templateUrl: './user.component.html',
  styleUrls: ['./user.component.less']
})
export class UserComponent implements OnInit {
  user: User;
  editMode: boolean;
  title: string;
  rights: any[];

  constructor(
    private userService: UserService,
    private rightService: RightService,
    private route: ActivatedRoute,
    private location: Location,
    private parserFormatter: NgbDateParserFormatter

  ) { }

  selectedRight(selected): void {
    this.user.Rights = this.user.Rights || [];
    this.user.Rights.push(selected);
  }

  removedRight(selected): void {
    this.user.Rights = this.user.Rights || [];
    var found = this.user.Rights.find(u => u.id == selected.id);
    var index = this.user.Rights.indexOf(found);
    if(index > -1)
      this.user.Rights.splice(index, 1);
  }

  ngOnInit(): void {
    this.rightService.getRights().then(rights => this.rights = rights);

    this.user = new User();
    this.editMode = true;
    this.route.params.subscribe(params => {
      if (params['id']) {
        this.userService.getUser(params['id'])
          .then(user => {
            this.user = user
            this.user.Rights = this.user.Rights || [];
          });
      }
      if (this.location.path().indexOf('details') > -1) {
        this.editMode = false;
        this.title = "Details";
      }
      else {
        if (params['id'])
          this.title = "Edit";
        else {
          this.title = "Create";
          this.user = new User();
          this.user.Rights = this.user.Rights || [];
        }
      }
    });
  }

  save(): void {
    if (this.user.id)
      this.userService.updateUser(this.user)
        .then(() => this.goBack());
    else
      this.userService.createUser(this.user)
        .then(() => this.goBack());
  }

  goBack(): void {
    this.location.back();
  }
}
