import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { User } from './models/user';
import { UserService } from './services/user.service';

@Component({
  selector: 'app-users',
  templateUrl: './users.component.html',
  styleUrls: ['./users.component.less']
})
export class UsersComponent implements OnInit {
  users: User[];

  constructor(
    private userService: UserService,
    private router: Router) { }

  getUsers(): void {
    this.userService
      .getUsers()
      .then(users => {
        debugger;
        this.users = users
      });
  }

  ngOnInit() {
    this.getUsers();
  }

}
