import { Injectable }    from '@angular/core';
import { Headers, Http } from '@angular/http';
import { User } from '../models/user';
import 'rxjs/add/operator/toPromise';
@Injectable()
export class UserService {
  private usersUrl = 'api/user';  // URL to web api
  constructor(private http: Http) { }

  getUsers(): Promise<User[]> {
    return this.http.get('http://localhost:1337/' + this.usersUrl)
      .toPromise()
      .then(response => 
        response.json().users as User[])
      ;
  }

}
