package hu.lanoga.dojo.api.right;

import hu.lanoga.dojo.util.LngComboTextValueEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by borosandras on 2017. 03. 28..
 */
@RestController
@CrossOrigin(origins = "*")
@RequestMapping(value = "api/right")
@Api(basePath = "/api/right", value = "DojoRight", description = "Endpoint for right management", produces = MediaType.APPLICATION_JSON_VALUE)
public class DojoRightController {

	@Autowired
	private DojoRightService dojoRightService;

	@ApiOperation(value = "Get right list")
	@RequestMapping(value = "", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public List<DojoRight> getRightList() {
		return dojoRightService.getAllRight();
	}

	@ApiOperation(value = "Get right list for combo")
	@RequestMapping(value = "get-rights-for-combo", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public List<LngComboTextValueEntity> getRightListForCombo() {
		return dojoRightService.getRightsForCombo();
	}

	@ApiOperation(value = "Get right with specified id")
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoRight getRight(@PathVariable("id") Integer id) {
		return dojoRightService.getRight(id);
	}

	@ApiOperation(value = "Get save new right")
	@RequestMapping(value = "", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoRight addRight(@RequestBody DojoRight user) {
		return dojoRightService.saveRight(user);
	}

	@ApiOperation(value = "Get update right")
	@RequestMapping(value = "", method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoRight editRight(@RequestBody DojoRight user) {
		return dojoRightService.saveRight(user);
	}

	@ApiOperation(value = "Delete right with given id")
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public void deleteRight(@PathVariable("id") Integer id) {
		dojoRightService.removeRight(id);
	}

}
