package hu.lanoga.dojo.api.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import hu.lanoga.dojo.api.right.DojoRight;
import hu.lanoga.dojo.util.LngComboTextValueEntity;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Dojo user entity
 *
 * Created by borosandras on 2017. 03. 22..
 */
@Setter
@Entity
@Table(name = "dojo_user")
public class DojoUser {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;
	private String firstName;
	private String lastName;
	private String userName;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
	private Date birthDate;
	@ManyToMany(fetch = FetchType.EAGER)
	@JoinTable(name = "user_x_right", joinColumns = {@JoinColumn(name = "user_id")}, inverseJoinColumns = {@JoinColumn(name = "right_id")})
	private List<DojoRight> rights;

	public DojoUser(String firstName, String lastName, String userName, Date birthDate, List<DojoRight> rights) {
		this.firstName = firstName;
		this.lastName = lastName;
		this.userName = userName;
		this.birthDate = birthDate;
		this.rights = rights;
	}

	public DojoUser() {
	}

	public Integer getId() {
		return id;
	}

	public String getFirstName() {
		return firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public String getUserName() {
		return userName;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	/**
	 * Transform user rights to an acceptable format for the ui
	 *
	 * @return List of id-text paierd entity for UI Combo
	 */
	public List<LngComboTextValueEntity> getRights() {
		return rights.stream()
				.map(right -> new LngComboTextValueEntity(right.getId(), right.getName()))
				.collect(Collectors.toList());
	}

	/**
	 * Return the original right array
	 *
	 * @return List of owned rights
	 */
	public List<DojoRight> getRightsEntity() {
		return rights;
	}
}
