package hu.lanoga.dojo.api.right;

import hu.lanoga.dojo.util.LngComboTextValueEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by borosandras on 2017. 03. 23..
 */
@Service
public class DojoRightService {
	@Autowired
	private DojoRightRepository dojoRightRepository;

	public List<DojoRight> getAllRight() {
		return dojoRightRepository.findAll();
	}

	public DojoRight saveRight(DojoRight user) {
		return dojoRightRepository.saveAndFlush(user);
	}

	public void removeRight(Integer id) {
		dojoRightRepository.delete(id);
	}

	public DojoRight getRight(Integer id) {
		return dojoRightRepository.findOne(id);
	}

	public List<LngComboTextValueEntity> getRightsForCombo() {
		return dojoRightRepository.findAll().stream()
				.map(right -> new LngComboTextValueEntity(right.getId(), right.getName()))
				.collect(Collectors.toList());
	}
}
