package hu.lanoga.dojo.api.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by borosandras on 2017. 03. 28..
 */
@RestController
@CrossOrigin(origins = "*")
@RequestMapping(value = "api/user")
@Api(basePath = "/api/user", value = "DojoUser", description = "Endpoint for user management", produces = MediaType.APPLICATION_JSON_VALUE)
public class DojoUserController {

	@Autowired
	private DojoUserService dojoUserService;

	@ApiOperation(value = "Get user list")
	@RequestMapping(value = "", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public List<DojoUser> getUserList() {
		return dojoUserService.getAllUser();
	}

	@ApiOperation(value = "Get user with specified id")
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoUser getUser(@PathVariable("id") Integer id) {
		return dojoUserService.getUser(id);
	}

	@ApiOperation(value = "Get save new user")
	@RequestMapping(value = "", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoUser addUser(@RequestBody DojoUser user) {
		return dojoUserService.saveUser(user);
	}

	@ApiOperation(value = "Get update user")
	@RequestMapping(value = "", method = RequestMethod.PUT, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public DojoUser editUser(@RequestBody DojoUser user) {
		return dojoUserService.saveUser(user);
	}

	@ApiOperation(value = "Delete user with given id")
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseStatus(HttpStatus.OK)
	public void deleteUser(@PathVariable("id") Integer id) {
		dojoUserService.removeUser(id);
	}

}
